unit CommonFunc;

interface

uses
  Forms, System.Variants, System.Classes, StrUtils, Vcl.Dialogs, Vcl.Controls,
  SysUtils, ComCtrls, IdHTTP, Winapi.Windows, Winapi.Messages;

type
  TVendor = array[0..11] of char;

procedure TypeStringToTarget(str: string; waitTime: Integer = 0);

function DialogQuestion(msg: string): boolean;

procedure DialogError(msg: string);

procedure DialogWarning(msg: string);

procedure DialogInformation(msg: string);

procedure Delay(MSecs: Cardinal);

function GetIpBydomain(domain: string): string;

function EncryptString(Source: string; Key: string=''): string;

function UnEncryptString(Source: string; Key: string=''): string;

implementation

//IP
function GetIpBydomain(domain: string): string;
var
  JSONStr: string;
  idhttp: TIdHttp;
begin
  idhttp := TIdHttp.Create;
  Result := '';
  try
    JSONStr := idhttp.Get('http://dns.alidns.com/resolve?name=' + domain + '&type=1&short=1');
    if JSONStr = '' then
      Exit;
    Result := Copy(JSONStr, 3, Length(JSONStr) - 4);
  finally
    idhttp.Free;
  end;
end;

procedure Delay(MSecs: Cardinal);
var
  WaitedTime: Cardinal;
begin
  WaitedTime := 0;
  while (WaitedTime < MSecs) do
  begin
    SleepEx(100, False);
    Inc(WaitedTime, 100);
    Application.ProcessMessages;
  end
end;

 //ַسȴʱ
procedure TypeStringToTarget(str: string; waitTime: Integer = 0);
var
  i: Integer;
begin
  //ַ
  for i := 1 to Length(str) do
  begin
    if (VkKeyScan(str[i]) > 256) then
    begin
      keybd_event(Ord(str[i]), 0, 0, 0);
      keybd_event(Ord(str[i]), 0, 2, 0);
    end
    else
    begin
      keybd_event(VkKeyScan(str[i]), 0, 0, 0);
      keybd_event(VkKeyScan(str[i]), 0, 2, 0);
    end;
  end;
  //س
  keybd_event(VK_RETURN, 0, 0, 0);
  Delay(waitTime);
end;

function DialogQuestion(msg: string): boolean;
begin
  Result := MessageDlg(msg, TMsgDlgType.mtConfirmation, [mbYes, mbNo], 0) = mrYes;
end;

procedure DialogError(msg: string);
begin
  MessageDlg(msg, TMsgDlgType.mtError, [TMsgDlgBtn.mbOK], 0);
end;

procedure DialogWarning(msg: string);
begin
  MessageDlg(msg, TMsgDlgType.mtWarning, [TMsgDlgBtn.mbOK], 0);
end;

procedure DialogInformation(msg: string);
begin
  MessageDlg(msg, TMsgDlgType.mtInformation, [TMsgDlgBtn.mbOK], 0);
end;

function EncryptString(Source: string; Key: string): string;
var
  KeyLen: integer;
  KeyPos: integer;
  Offset: integer;
  Dest: string;
  SrcPos: integer;
  SrcAsc: integer;
  Range: integer;
begin
  KeyLen := Length(Key);
  if KeyLen = 0 then
    Key := 'delphi';
  KeyPos := 0;
  Range := 256;
  randomize;
  Offset := random(Range);
  Dest := format('%1.2x', [Offset]);
  for SrcPos := 1 to Length(Source) do
  begin
    SrcAsc := (Ord(Source[SrcPos]) + Offset) mod 255;
    if KeyPos < KeyLen then
      KeyPos := KeyPos + 1
    else
      KeyPos := 1;
    SrcAsc := SrcAsc xor Ord(Key[KeyPos]);
    Dest := Dest + format('%1.2x', [SrcAsc]);
    Offset := SrcAsc;
  end;
  result := Dest;
end;

function UnEncryptString(Source: string; Key: string): string;
var
  KeyLen: integer;
  KeyPos: integer;
  Offset: integer;
  Dest: string;
  SrcPos: integer;
  SrcAsc: integer;
  TmpSrcAsc: integer;
begin
  KeyLen := Length(Key);
  if KeyLen = 0 then
    Key := 'delphi';
  KeyPos := 0;
  Offset := strtoint('$' + copy(Source, 1, 2));
  SrcPos := 3;
  repeat
    SrcAsc := strtoint('$' + copy(Source, SrcPos, 2));
    if KeyPos < KeyLen then
      KeyPos := KeyPos + 1
    else
      KeyPos := 1;
    TmpSrcAsc := SrcAsc xor Ord(Key[KeyPos]);
    if TmpSrcAsc <= Offset then
      TmpSrcAsc := 255 + TmpSrcAsc - Offset
    else
      TmpSrcAsc := TmpSrcAsc - Offset;
    Dest := Dest + chr(TmpSrcAsc);
    Offset := SrcAsc;
    SrcPos := SrcPos + 2;
  until SrcPos >= Length(Source);
  result := Dest;
end;

end.

